 ; Ŀ
 ;   Phd - change text entities from big font styles to standard.          
 ;   Copyright 1997, 2002 by Rocket Software Ltd.                          
 ;   Why is there Baked Alaska but no Boiled Alaska?                       
 ; 

 ; Ŀ
 ;   Tbx - text outliner.                                                  
 ; 
 (DEFUN TBX (enam / aa bb rota cc dd bheigt bwidth llangg lldist ll ul lr ur)
  (setq aa (entget enam))
 ; Ŀ
 ;   The textbox function returns...hang on...from the notes below, a      
 ;   list containing the offset of the lower left point of the text from   
 ;   the 10 association point - typically 0,0,0 - and the offset of the    
 ;   upper right point from the ten point.  These are assuming that the    
 ;   text isn't obliqued or rotated, so if it is the program must adjust   
 ;   accordingly.  This program won't bother with obliquing, rotation is   
 ;   allowed.                                                              
 ; 
  (setq bb (textbox aa))
  (setq rota (cdr (assoc 50 aa)))
  (setq cc (car bb))                    ; ll offset from 10 of text
  (setq dd (cadr bb))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
  (setq ll (polar (cdr (assoc 10 aa)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 ; Ŀ
 ;   We now have the real upper left, upper right, etc. points of the      
 ;   text.                                                                 
 ; 
  (grdraw ll ul 3)
  (grdraw ul ur 3)
  (grdraw ur lr 3)
  (grdraw lr ll 3)
 (list ll ul ur lr))
 ; Ŀ
 ;   Tbx end.                                                              
 ; 

 ; Ŀ
 ;   Subroutine CI - grdraw circle maker.                                  
 ; 
 (DEFUN CI (pa radd / reps colo angg incr pa1 pa2)
  (setq reps 32)
  (setq colo 2)
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (setq pa1 (polar pa angg radd))
  (repeat reps
          (setq angg (+ angg incr))
          (setq pa2 (polar pa angg radd))
          (grdraw pa1 pa2 colo)
          (setq pa1 pa2))
 (princ))
 ; Ŀ
 ;   Ci end.                                                               
 ; 

 ; Ŀ
 ;   Le - mark a point.                                                    
 ; 
 (DEFUN LE (aa bb / blip rad ang s1 s2)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq rad (/ (getvar "viewsize") 20))
  (grdraw aa bb 1)
  (setq ang (angle aa bb))
  (setq s1 (polar aa ang (* rad 3)))
  (setq s2 (polar s1 (+ ang (/ pi 2)) (/ rad 2)))
  (setq s1 (polar s2 (+ ang (* pi 1.5)) rad))
  (grdraw s1 s2 1)
  (grdraw s2 aa 1)
  (grdraw aa s1 1)
  (setvar "blipmode" blip)
 (princ))
 ; Ŀ
 ;   Le end.                                                               
 ; 

 ; Ŀ
 ;   Vortex - mark a point passed as the only argument.                    
 ; 
 (DEFUN VORTEX (pa rad / reps colo rad2 angg incr ang2)
  (setq reps 75)
  (setq colo 4)
  (setq rad2 (* rad 2))
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (repeat reps
          (setq ang2 (+ angg (/ pi 5)))
          (grdraw (polar pa angg rad2) (polar pa ang2 rad) colo)
          (setq angg (+ angg incr)))
 (princ))
 ; Ŀ
 ;   Vortex end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Farcrn - find the corner of the screen furthest away from  
 ;   selected point.                                                       
 ;   Takes one argument, a point, returns a point.                         
 ; 
 (DEFUN FARCRN (pa / pax pay a vs ctr w maxx minx maxy miny pfar)
  (setq pax (car pa))
  (setq pay (cadr pa))
  (setq a (getvar "screensize"))           ; view height & width (pixels)
  (setq a (/ (car a) (cadr a)))            ; view width/height ratio
  (setq vs (* (getvar "viewsize") 0.5))    ; view height in drawing units
  (setq ctr (getvar "viewctr"))            ; centre point of screen
  (setq w (* vs a ))                       ; view half width
  (setq maxx (+ (car ctr) w))
  (setq minx (- (car ctr) w))
  (setq maxy (+ (cadr ctr) vs))
  (setq miny (- (cadr ctr) vs))
  (if (> (- maxx pax) (- pax minx))
      (if (> (- maxy pay) (- pay miny))
          (setq pfar (list maxx maxy))
          (setq pfar (list maxx miny)))
      (if (> (- maxy pay) (- pay miny))
          (setq pfar (list minx maxy))
          (setq pfar (list minx miny))))
 pfar)
 ; Ŀ
 ;   Subroutine Farcrn end.                                                
 ; 

 ; Ŀ
 ;   Phd.                                                                  
 ; 
 (DEFUN C:PHD (/ fixp reww stylc asoc4 stlnam num ss enam entt pa pb ptlst ll
                                                              ur lr midd radd)
  (setvar "cmdecho" 0)
  (command "undo" "m")
 ; Ŀ
 ;   Make sure the user knows what he is doing - at least in this respect. 
 ; 
  (initget "Yes No")
  (setq fixp (getkword "Remove big font text styles? <Y>: "))
  (setq reww t)
  (while (setq stylc (tblnext "style" reww))
         (setq reww ())
         (if (/= (cdr (setq asoc4 (assoc 4 stylc))) "")
             (progn
                  (setq stlnam (cons 7 (cdr (assoc 2 stylc))))
                  (setq num 0)
                  (if (setq ss (ssget "X" (list stlnam)))
                      (while (setq enam (ssname ss num))
                             (setq num (1+ num))
                             (setq entt (entget enam))
                             (setq pa (cdr (assoc 10 entt)))
 ; Ŀ
 ;   Fix the style if required.                                            
 ; 
                             (if (or (= fixp "Yes") (null fixp))
                                 (entmod (subst (cons 7 "STANDARD")
                                                (assoc 7 entt) entt)))
 ; Ŀ
 ;   Find the furthest screen corner from the entity insertion.            
 ; 
                             (setq pb (farcrn pa))
 ; Ŀ
 ;   Box the text.                                                         
 ; 
                             (setq ptlst (tbx enam))
                             (setq ll (car ptlst))
                             (setq ur (caddr ptlst))
                             (setq lr (cadddr ptlst))
                             (setq midd (polar ll (angle ll ur)
                                        (/ (distance ll ur) 2)))
                             (setq radd (/ (distance ll lr) 2))
 ; Ŀ
 ;   Mark its insertion.                                                   
 ; 
                             (vortex midd radd)
                             (ci midd radd)
 ; Ŀ
 ;   Draw a pointer to it.                                                 
 ; 
                             (le midd pb))))))
  (command "undo" "end")
 (princ))